using System;
using System.Linq;
using System.Collections.Generic;

class Solution {
  public static void Main(string[] args) {
    //GLORY TO UKRAINE!
    //data
    string data = Console.ReadLine();
    List<string> names = new List<string>();
    List<string> open = new List<string>();
    List<string> close = new List<string>();
    string alphabet = "abcdefghijklmnopqrstuvwxyz";

    //solution
    bool isPerfect = true;
    bool isClosing = false;
    bool inBrackets = false;
    string currentName = "";

    for (int i = 0; i < data.Length; i++)
    {
        if (data[i] == '<')
        {
            inBrackets = true;
        }
        else if (data[i] == '>')
        {
            if (isClosing)
            {
                close.Add(currentName);
                names.Add(currentName);
            }
            else
            {
                open.Add(currentName);
            }
            currentName = "";
            inBrackets = false;
            isClosing = false;
        }
        else if ((data[i] == '/' && currentName.Length == 0) && inBrackets)
        {
            isClosing = true;
        }
        else if (alphabet.Contains(data[i]))
        {
            currentName += Convert.ToString(data[i]);
        }
        else
        {
            isPerfect = false;
            break;
        }
    }

    foreach (string name in names)
    {
        if (open.Contains(name) && close.Contains(name))
        {
            open.Remove(name);
            close.Remove(name);
        }
        else
        {
            isPerfect = false;
            break;
        }
    }

    bool answer = isPerfect && open.Count() == 0;
    Console.WriteLine(answer ? "Yes" : "No");
  }
}
